TITLE   'Field Around a Wire in (r,z)'				{ exa131.pde }
SELECT    								{ Student Edition }
   errlim=1e-12     ngrid=1     spectral_colors	
COORDINATES   cartesian1
VARIABLES   Az                   		{ Magnetic vector potential }
DEFINITIONS                      					{ SI units }
   mu0=4*pi*1e-7     mu=mu0     Jz0=1.0			{ Current density }
   r0=0.2     Lr=1.0     Lz=0.01
   B_phi=-dx( Az)     H_phi=1/mu*B_phi  	
   Jz     B_ex							{ Declared only }
EQUATIONS
   1/r*dx( r/mu*dx( Az))=-Jz
BOUNDARIES
region 'domain'  Jz=0    B_ex=mu*Jz0*r0^2/(2*r)  	{ Exact solution }
   start 'outer' (0)  line to (Lr) point value(Az)=0
region 'wire' Jz=Jz0  B_ex=mu*Jz0*r/2			
   start (0) line to (r0)
PLOTS
   elevation( Az) from (0,0) to (Lr,0)
   elevation( B_phi, B_ex) from (0,0) to (Lr,0)
   elevation( B_phi- B_ex) from (0,0) to (Lr,0) report(globalmax( B_phi))
END







